% Quokka3 example for a 3T tandem using the simplified 'IBC' syntax
% bottom-cell properties are made-up, does not represent a specific real cell but a generic TBC cell
% top-cell properties are taken from KAUST tandem example

% this example shows how for high voltage-match ratio, photon-coupling substantially boost

% (c) 2025 Andreas Fell

Syntax = 'IBC';

DomainType = 'standard';

Sweep.Enable = 1;
Sweep.NGroups = 2;
Sweep.GroupA(1).Parameter = 'Solver.Electrical.3T.SecondaryVoltage.VoltageMatchRatio';
Sweep.GroupA(1).Values = [1.5 2 3];
Sweep.GroupB(1).Parameter = 'Solver.Electrical.3T.PrimaryJV';
Sweep.GroupB(1).Values = ['maincell' 'subcell'];


CellThickness = 140;

Thermal.T = 25 degC;

FingerPitch = 1.5 mm;

NSkin.Width = 0.5mm;
NContact.Width = 50;
NContact.OhmicResistivity = 1e-4;
NFinger.Width = 50;

PSkin.WidthFromPitch = 1; % means that the width of the P-region is calculated from finger pitch, gap width and N-region width
PContact.Width = 50;
PContact.OhmicResistivity = 1e-4;
PFinger.Width = 50;

FrontFinger.Width = 30;
FrontFinger.Pitch = 1 mm;
FrontContact.OhmicResistivity = 1e-4;
FrontFinger.ShadingFraction = 0.7;

Solver.SolutionType = 'light JV-curve';
Solver.JVCurve.VtermStepSize = 'fine';
Solver.SingleJVPoint.Type = 'MPP';
Solver.Electrical.MetalModelType = 'constant-potential';
Solver.Electrical.SkinJ0nieff.Type = 'user-T';
Solver.Electrical.SkinJ0nieff.T = 298.15;
Solver.LuminescentCoupling.Enable = 1;
Solver.PhotonRecycling.Enable = 1;

Solver.Electrical.3T.Enable = 1;
Solver.Electrical.3T.PrimaryJV = 'maincell';
Solver.Electrical.3T.SecondaryVoltage.Type = 'voltage-match';
Solver.Electrical.3T.SecondaryVoltage.VoltageMatchRatio = 1.7;
Solver.Electrical.3T.MPPType = 'both cells'; % or 'primary cell'; in any case JV-curve of primary cell is simulated, only MPP finding is either performed using the primary cell power or the total 3T power (sum of power of both cells)


Optical.GenerationModelType = 'Text-Z';
Optical.FrontIllumination.Enable = 1;
Optical.FrontIllumination.Scale = 1;
Optical.TextZ.FrontText.Type = 'detailed';
Optical.TextZ.FrontText.FacetAngle = 54;
Optical.TextZ.FrontText.Detailed.SurfaceMorphology = 'Rantex';
Optical.TextZ.FrontText.Detailed.TextureAngle = 54;
Optical.TextZ.FrontText.Layer(1).Material = 'i-aSi';
Optical.TextZ.FrontText.Layer(1).Thickness = 8;
Optical.TextZ.FrontText.Layer(2).Material = 'n-ncSi';
Optical.TextZ.FrontText.Layer(2).Thickness = 20;
Optical.TextZ.FrontText.Layer(3).Material = 'rec-IZO';
Optical.TextZ.FrontText.Layer(3).Thickness = 5;
Optical.TextZ.FrontText.Layer(4).Material = '2PACz';
Optical.TextZ.FrontText.Layer(4).Thickness = 2;
Optical.TextZ.FrontText.Layer(5).Material = 'PVK';
Optical.TextZ.FrontText.Layer(5).Thickness = 800;
Optical.TextZ.FrontText.Layer(5).Cell = 'SubCell';
Optical.TextZ.FrontText.Layer(5).EtaColl = 1;
Optical.TextZ.FrontText.Layer(6).Material = 'LiF';
Optical.TextZ.FrontText.Layer(6).Thickness = 1;
Optical.TextZ.FrontText.Layer(7).Material = 'C60';
Optical.TextZ.FrontText.Layer(7).Thickness = 12;
Optical.TextZ.FrontText.Layer(8).Material = 'SnO2';
Optical.TextZ.FrontText.Layer(8).Thickness = 10;
Optical.TextZ.FrontText.Layer(9).Material = 'front-IZO';
Optical.TextZ.FrontText.Layer(9).Thickness = 40;
Optical.TextZ.FrontText.Layer(10).Material = 'MgF2';
Optical.TextZ.FrontText.Layer(10).Thickness = 100;
Optical.TextZ.FrontZ.Type = 'local';
Optical.ScaleGeneration = 1;


Bulk.BackgroundDoping.SettingType = 'dopingtype-resistivity';
Bulk.BackgroundDoping.DopingType = 'n-type';
Bulk.BackgroundDoping.Resistivity = 1;
Bulk.Electrical.Recombination.Type = 'intrinsic plus fixed-lifetime';
Bulk.Electrical.Recombination.FixedLifetime = 15ms % defect-lifetime / SRH contriution


FullFrontSkin.ElectricalModelType = 'lumped';
FullFrontSkin.Lumped.Electrical.RsheetEnable = 1;
FullFrontSkin.Lumped.Electrical.Rsheet = 150;
FullFrontSkin.Lumped.Electrical.ConductionType = 'n-type';
FullFrontSkin.Lumped.Electrical.NonContactedRecombination.ModelType = 'J0';
FullFrontSkin.Lumped.Electrical.NonContactedRecombination.J0 = 2e-15;
FullFrontSkin.Lumped.Optical.Internal.Rint = 0.92; % ideal Lambertian front side reflectivity
FullFrontSkin.Lumped.Optical.Internal.Diffuse = 1;
FullFrontSkin.Lumped.Optical.Internal.Scatter = 1;
FullFrontSkin.Layer(1).Name = 'PVK absorber';
FullFrontSkin.Layer(1).Type = 'lumped-subcell';
FullFrontSkin.Layer(1).Subcell.JVType = 'two-diode';
FullFrontSkin.Layer(1).Subcell.J01 = 4e-23 A/cm2;
FullFrontSkin.Layer(1).Subcell.J02 = 1e-13 A/cm2;
FullFrontSkin.Layer(1).Subcell.Rseries = 1 Ohmcm2;
FullFrontSkin.Layer(1).Subcell.Rshunt = 500 Ohmcm2;
FullFrontSkin.Layer(1).Subcell.Reverse = 0;

NSkin.ElectricalModelType = 'lumped';
NSkin.Lumped.Electrical.RsheetEnable = 1;
NSkin.Lumped.Electrical.Rsheet = 1000; % this Rsheet is in parallel to Layer(1), i.e. the in-diffusion only
NSkin.Lumped.Electrical.NonContactedRecombination.ModelType = 'J0';
NSkin.Lumped.Electrical.NonContactedRecombination.J0 = 1e-15;
NSkin.Lumped.Electrical.ContactedRecombination.ModelType = 'J0';
NSkin.Lumped.Electrical.ContactedRecombination.J0 = 30e-15;
NSkin.Lumped.Optical.Internal.Rint = 1; % assumes reflective chuck measurement
NSkin.Lumped.Optical.Internal.Diffuse = 0;
NSkin.Lumped.Optical.Internal.ApppType = 'from layers';
NSkin.Layer(1).Name = 'rear n poly-Si';
NSkin.Layer(1).Type = 'transport';
NSkin.Layer(1).ConductionType = 'n-type';
NSkin.Layer(1).Thickness = 50 nm;
NSkin.Layer(1).Material = 'Si';
NSkin.Layer(1).RsheetType = 'model';
NSkin.Layer(1).ApppType = 'model';
NSkin.Layer(1).DopingDensityType = 'user';
NSkin.Layer(1).DopingDensity = 2e20; % the doping density influences both parasitic aborption (Appp) and Rsheet 

PSkin.ElectricalModelType = 'lumped';
PSkin.Lumped.Electrical.RsheetEnable = 1;
PSkin.Lumped.Electrical.Rsheet = 1000; % this Rsheet is in parallel to Layer(1), i.e. the in-diffusion only
PSkin.Lumped.Electrical.NonContactedRecombination.ModelType = 'J0';
PSkin.Lumped.Electrical.NonContactedRecombination.J0 = 3e-15;
PSkin.Lumped.Electrical.ContactedRecombination.ModelType = 'J0';
PSkin.Lumped.Electrical.ContactedRecombination.J0 = 30e-15;
PSkin.Lumped.Optical.Internal.Rint = 1; % assumes reflective chuck measurement
PSkin.Lumped.Optical.Internal.Diffuse = 1;
PSkin.Lumped.Optical.Internal.ApppType = 'from layers';
PSkin.Layer(1).Name = 'rear p poly-Si';
PSkin.Layer(1).Type = 'transport';
PSkin.Layer(1).ConductionType = 'p-type';
PSkin.Layer(1).Thickness = 50 nm;
PSkin.Layer(1).Material = 'Si';
PSkin.Layer(1).RsheetType = 'model';
PSkin.Layer(1).ApppType = 'model';
PSkin.Layer(1).DopingDensityType = 'user';
PSkin.Layer(1).DopingDensity = 2e20; % the doping density influences both parasitic aborption (Appp) and Rsheet 

Material.User(1).Name = 'i-aSi';
Material.User(1).nkModel = 'user';
Material.User(1).nk.n.Type = 'file';
Material.User(1).nk.n.File = 'nk_data/i a-Si_n.csv';
Material.User(1).nk.k.Type = 'file';
Material.User(1).nk.k.File = 'nk_data/i a-Si_k.csv';

Material.User(2).Name = 'n-ncSi';
Material.User(2).nkModel = 'user';
Material.User(2).nk.n.Type = 'file';
Material.User(2).nk.n.File = 'nk_data/nc-n Si_n.csv';
Material.User(2).nk.k.Type = 'file';
Material.User(2).nk.k.File = 'nk_data/nc-n Si_k.csv';

Material.User(3).Name = 'rec-IZO';
Material.User(3).nkModel = 'user';
Material.User(3).nk.n.Type = 'file';
Material.User(3).nk.n.File = 'nk_data/middle IZO_n.csv';
Material.User(3).nk.k.Type = 'file';
Material.User(3).nk.k.File = 'nk_data/middle IZO_k.csv';

Material.User(4).Name = '2PACz';
Material.User(4).nkModel = 'user';
Material.User(4).nk.n.Type = 'file';
Material.User(4).nk.n.File = 'nk_data/2PACz_n.csv';
Material.User(4).nk.k.Type = 'file';
Material.User(4).nk.k.File = 'nk_data/2PACz_k.csv';

Material.User(5).Name = 'PVK';
Material.User(5).nkModel = 'user';
Material.User(5).nk.n.Type = 'file';
Material.User(5).nk.n.File = 'nk_data/PVK_n.csv';
Material.User(5).nk.k.Type = 'file';
Material.User(5).nk.k.File = 'nk_data/PVK_k.csv';

Material.User(6).Name = 'LiF';
Material.User(6).nkModel = 'user';
Material.User(6).nk.n.Type = 'file';
Material.User(6).nk.n.File = 'nk_data/LiF_n.csv';
Material.User(6).nk.k.Type = 'file';
Material.User(6).nk.k.File = 'nk_data/LiF_k.csv';

Material.User(7).Name = 'C60';
Material.User(7).nkModel = 'user';
Material.User(7).nk.n.Type = 'file';
Material.User(7).nk.n.File = 'nk_data/C60_n.csv';
Material.User(7).nk.k.Type = 'file';
Material.User(7).nk.k.File = 'nk_data/C60_k.csv';

Material.User(8).Name = 'SnO2';
Material.User(8).nkModel = 'user';
Material.User(8).nk.n.Type = 'file';
Material.User(8).nk.n.File = 'nk_data/SnO2_n.csv';
Material.User(8).nk.k.Type = 'file';
Material.User(8).nk.k.File = 'nk_data/SnO2_k.csv';

Material.User(9).Name = 'front-IZO';
Material.User(9).nkModel = 'user';
Material.User(9).nk.n.Type = 'file';
Material.User(9).nk.n.File = 'nk_data/top IZO_n.csv';
Material.User(9).nk.k.Type = 'file';
Material.User(9).nk.k.File = 'nk_data/top IZO_k.csv';

Material.User(10).Name = 'MgF2';
Material.User(10).nkModel = 'user';
Material.User(10).nk.n.Type = 'file';
Material.User(10).nk.n.File = 'nk_data/MgF_n.csv';
Material.User(10).nk.k.Type = 'file';
Material.User(10).nk.k.File = 'nk_data/MgF_k.csv';